#!/usr/bin/env python3

import sys
import argparse

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('file', nargs=1, type=str)
    parser.add_argument('text', nargs=1, type=str)
    args = parser.parse_args()

    text = args.text[0]

    with open(args.file[0], 'r', encoding='utf-8') as f:
        for line in f:
            if line.strip() == text:
                return 0

    return 1

if __name__ == '__main__':
    sys.exit(main())
